<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/ticket.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
                <hr>
                <p><b>Ruc:</b> <?php echo $data['empresa']['identidad']; ?></p>
                <p><b>Teléfono:</b> <?php echo $data['empresa']['telefono']; ?></p>
                <p><b>Dirección:</b> <?php echo $data['empresa']['direccion']; ?></p>
            </td>
        </tr>
    </table>
    <h5 class="title">Datos del Cliente</h5>
    <table>
        <tr>
            <td colspan="2">
                <strong>Nombre: </strong>
                <p><?php echo $data['abono']['nombre'] ?></p>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Teléfono: </strong>
                <p><?php echo $data['abono']['telefono'] ?></p>
            </td>
            <td>
                <strong>Dirección: </strong>
                <p><?php echo $data['abono']['direccion'] ?></p>
            </td>
        </tr>
    </table>
    <h5 class="title">Detalle del abono</h5>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-left">Monto</th>
                <th class="text-left">Abonado</th>
                <th class="text-right">Restante</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text-right"><?php echo number_format($data['abono']['monto'], 2); ?></td>
                <td class="text-right"><?php echo number_format($data['abono']['abonado'], 2); ?></td>
                <td class="text-right"><?php echo number_format($data['abono']['restante'], 2); ?></td>
            </tr>
            <tr class="total">
                <td class="text-right" colspan="2">Total</td>
                <td class="text-right"><?php echo number_format($data['abono']['total'], 2); ?></td>
            </tr>
        </tbody>
    </table>
    <div class="mensaje">
        <?php echo $data['empresa']['mensaje']; ?>
    </div>

</body>

</html>