<?php
class UsuariosModel extends Query{
    public function __construct()
    {
        parent::__construct();
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    
    public function getUsuarios()
    {
        $sql = "SELECT * FROM usuarios";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getCajas()
    {
        $sql = "SELECT * FROM cajas WHERE estado = 1";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function registrarUsuario(string $usuario,string $nombre, string $correo, string $clave, int $caja)
    {
        $vericar = "SELECT * FROM usuarios WHERE usuario = '$usuario'";
        $existe = $this->select($vericar);
        if (empty($existe)) {
            # code...
            $sql = "INSERT INTO usuarios(usuario,nombre,correo, clave, id_caja) VALUES (?,?,?,?,?)";
            $datos = array($usuario, $nombre,$correo, $clave, $caja);
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "ok";
            }else{
                $res = "error";
            }
        }else{
            $res = "existe";
        }
        return $res;
    }
    public function modificarUsuario(string $usuario, string $nombre, string $correo, int $caja, int $id)
    {
        $verificar = "SELECT * FROM usuarios WHERE usuario = '$usuario' AND id != $id";
        $existe = $this->select($verificar);
        if (empty($existe)) {
            $sql = "UPDATE usuarios SET usuario = ?, nombre = ?, correo = ?, id_caja=? WHERE id = ?";
            $datos = array($usuario, $nombre, $correo, $caja, $id);
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "modificado";
            } else {
                $res = "error";
            }
        }else{
            $res = "existe";
        }
        return $res;
    }
    public function editarUser(int $id)
    {
        $sql = "SELECT * FROM usuarios WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function accionUser(int $estado, int $id)
    {
        $sql = "UPDATE usuarios SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        return $data;
    }
    public function getPerfil(int $id)
    {
        $sql = "SELECT * FROM usuarios WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function actualizarPass(string $clave, int $id)
    {
        $sql = "UPDATE usuarios SET clave = ? WHERE id = ?";
        $datos = array($clave, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function getPermisos()
    {
        $sql = "SELECT * FROM permisos";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getDetallePermisos(int $id)
    {
        $sql = "SELECT * FROM detalle_permisos WHERE id_usuario = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function deletePermisos(int $id)
    {
        $sql = "DELETE FROM detalle_permisos WHERE id_usuario = ?";
        $datos = array($id);
        $data = $this->save($sql, $datos);
        return $data;
    }

    public function actualizarPermisoBackup(int $usuario, int $permiso)
    {
        $sql = "INSERT INTO detalle_permisos (id_usuario, id_permiso) VALUES (?,?)";
        $datos = array($usuario, $permiso);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }    

    public function actualizarPermisos(int $usuario, array $permisos)
    {
        if (empty($permisos)) {
            return "ok";
        }
        
        // Construir INSERT múltiple: VALUES (1,5), (1,8), (1,12)...
        $placeholders = array();
        $datos = array();
        
        foreach ($permisos as $permiso) {
            $placeholders[] = "(?, ?)";
            $datos[] = $usuario;
            $datos[] = $permiso;
        }
        
        $sql = "INSERT INTO detalle_permisos (id_usuario, id_permiso) VALUES " . implode(", ", $placeholders);
        $data = $this->save($sql, $datos);
        
        return ($data >= 1) ? "ok" : "error";
    }
    public function getCorreo(string $correo)
    {
        $sql = "SELECT * FROM usuarios WHERE correo = '$correo'";
        $data = $this->select($sql);
        return $data;
    }
    public function getToken(string $token)
    {
        $sql = "SELECT * FROM usuarios WHERE token = '$token'";
        $data = $this->select($sql);
        return $data;
    }
    public function actualizarToken(string $token, string $correo)
    {
        $sql = "UPDATE usuarios SET token = ? WHERE correo = ?";
        $datos = array($token, $correo);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function resetearPass(string $clave, int $id, string $token)
    {
        $sql = "UPDATE usuarios SET clave = ?, token = ? WHERE id = ? AND token = ?";
        $datos = array($clave, '', $id, $token);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
}
?>