<?php
class Compras extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'jquery-ui.min.js'),
            array('script' => 'pages/compras.js')
        );
        $this->views->getView('compras', "index", $data);
    }
    public function buscarProducto()
    {
        $data = $this->model->buscarProducto($_GET['pro']);
        $datos = array();
        foreach ($data as $row) {
            $data['id'] = $row['id'];
            $data['label'] = $row['codigo'] . ' - ' . $row['descripcion'];
            $data['value'] = $row['codigo'];
            $data['precio'] = $row['precio_compra'];
            $data['descripcion'] = $row['descripcion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function buscarProveedor()
    {
        $data = $this->model->buscarProveedor($_GET['q']);
        $datos = array();
        foreach ($data as $row) {
            $data['id'] = $row['id'];
            $data['label'] = $row['ruc'] . ' - ' . $row['nombre'];
            $data['value'] = $row['ruc'];
            $data['nombre'] = $row['nombre'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function ingresar($id_pro)
    {
        $datos = $this->model->getProducto($id_pro);
        $precio = $datos['precio_compra'];
        $cantidad = 1;
        $comprobar = $this->model->getComprobar($id_pro, $this->id_usuario, 'detalle');
        if (empty($comprobar)) {
            $sub_total = $precio * $cantidad;
            $data = $this->model->registrarDetalle($id_pro, $this->id_usuario, $precio, $cantidad, $sub_total);
            if ($data == "ok") {
                $msg = array('msg' => 'Producto ingresado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al ingresar el producto', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'El producto ya esta agregado', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function listar($table)
    {
        $data['detalle'] = $this->model->getDetalle($this->id_usuario, $table);
        $data['total_pagar'] = $this->model->calcularCompra($this->id_usuario, $table);
        $data['series'] = $this->model->getSeries();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function delete($id)
    {
        $data = $this->model->deleteDetalle($id, 'detalle');
        if ($data == 'ok') {
            $msg = array('msg' => 'Producto Eliminado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el producto', 'icono' => 'error');
        }
        echo json_encode($msg);
        die();
    }
    //Historial Compras
    public function historial()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'sum().js'),
            array('script' => 'pages/historial_compras.js'),
        );
        $this->views->getView('compras', "historial", $data);
    }
    public function listar_historial()
    {
        $data = $this->model->getCompras($this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            $url = base_url . 'compras/generarPdf/' . $data[$i]['id'];
            if ($data[$i]['forma_pago'] == 1) {
                $data[$i]['forma'] = '<span class="badge badge-info">Contado</span>';
            } else {
                $data[$i]['forma'] = '<span class="badge badge-warning">Credito</span>';
            }
            if ($data[$i]['estado'] == 1 && $data[$i]['forma_pago'] == 1) {
                $data[$i]['estado'] = '<span class="badge badge-success">Pagado</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                        <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                        <button class="btn btn-outline-warning" type="button" onclick="btnAnular(' . $data[$i]['id'] . ');"><i class="fas fa-ban"></i></button>
                    <div/>';
            } else if ($data[$i]['estado'] == 1 && $data[$i]['forma_pago'] == 2) {
                $data[$i]['estado'] = '<span class="badge badge-warning">Pendiente</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                        <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                        <button class="btn btn-outline-warning" type="button" onclick="btnAnular(' . $data[$i]['id'] . ');"><i class="fas fa-ban"></i></button>
                    <div/>';
            } else if ($data[$i]['estado'] == 2 && $data[$i]['forma_pago'] == 2) {
                $data[$i]['estado'] = '<span class="badge badge-success">Completado</span>';
                $data[$i]['acciones'] = '<div>
                <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                <div/>';
            } else {
                $data[$i]['estado'] = '<span class="badge badge-danger">Anulado</span>';
                $data[$i]['acciones'] = '<div>
                <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                <div/>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function generar()
    {
        if (empty($_POST['serie'])) {
            $msg = array('msg' => 'La serie es requerido', 'icono' => 'error');
        } else {
            $id_proveedor = strClean($_POST['id_proveedor']);
            $anotacion = $_POST['anotacion'];
            $forma = strClean($_POST['forma']);
            $serie = strClean($_POST['serie']);
            $anotacion = $_POST['anotacion'];
            
            $data = $this->model->getDetalle($this->id_usuario, 'detalle');
            $pagar = $this->model->calcularCompra($this->id_usuario, 'detalle');
            $fecha = $_POST['fecha'];
            $hora = date('H:i:s');
            $compra = $this->model->insertarCompra($this->id_usuario, $pagar['total'], $id_proveedor, $fecha, $hora, $forma, $serie,$anotacion);
            if ($compra > 0) {
                if ($forma == 2) {
                    $this->model->insertarCreditoCompra($compra, $pagar['total'], $id_proveedor, $fecha, $this->id_usuario);
                }
                foreach ($data as $row) {
                    $id_pro = $row['id_producto'];
                    $cantidad = $row['cantidad'];
                    $precio = $row['precio'];
                    $descuento = $row['descuento'];
                    $sub_total = $row['sub_total'];
                    $this->model->registrarDetalles($compra, $id_pro, $cantidad, $descuento, $precio, $sub_total);
                    $stock = $this->model->getProducto($id_pro);
                    $total_cantidad = $stock['cantidad'] + $row['cantidad'];
                    $this->model->actualizarStock($total_cantidad, $stock['id']);
                }
                $eliminar = $this->model->eliminarTemp($this->id_usuario, 'detalle');
                if ($eliminar == 'ok') {
                    $msg = array('msg' => 'Compra Generada', 'folio' => $compra, 'icono' => 'success');
                }
            } else {
                $msg = array('msg' => 'Error al generar la compra', 'icono' => 'error');
            }
            echo json_encode($msg, JSON_UNESCAPED_UNICODE);
            die();
        }
    }
    public function anular($id)
    {
        if (isset($_GET)) {
            $existe = $this->model->getDetalleCompra('detalle_compra', $id);
            if (!empty($existe)) {
                foreach ($existe as $row) {
                    $stock = $this->model->getProducto($row['id_producto']);
                    $cantidad = $stock['cantidad'] - $row['cantidad'];
                    $this->model->actualizarStock($cantidad, $stock['id']);
                }
                $datos_venta = $this->model->getDatos('compras', $id);
                if ($datos_venta['forma_pago'] == 2) {
                    $this->model->anularCredito('creditos', $id);
                }
                $data = $this->model->anular('compras', $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Compra anulada', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al anular la compra', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'Error al anular la compra', 'icono' => 'error');
            }
            echo json_encode($msg);
            die();
        }
    }
    //Precio producto
    public function precioProducto($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $precio = $array[1];
        if (is_numeric($id) && is_numeric($precio)) {
            if ($precio > '') {
                $data = $this->model->actualizarPrecio('detalle', $precio, $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al agregar la precio', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    //Cantidad compras
    public function cantidadCompra($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $cant = $array[1];
        if (is_numeric($id) && is_numeric($cant)) {
            if ($cant > '') {
                $data = $this->model->actualizarCantidad('detalle', $cant, $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al agregar la cantidad', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    //descuento compras
    public function descuentoCompra($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $desc = $array[1];
        if (is_numeric($id) && is_numeric($desc)) {
            $data = $this->model->actualizarDescuento('detalle', $desc, $id);
            if ($data == 'ok') {
                $msg = array('msg' => 'Descuento Agregado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al agregar el descuento', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    //pdf Compras
    public function generarPdf($folio)
    {
        $data['empresa'] = $this->model->getEmpresa();
        $data['compra'] = $this->model->getCompra($folio);
        $data['detalle'] = $this->model->detalleCompras($folio);
        ob_start();
        $html = $this->views->getView('compras', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        if ($data['compra']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
}
