<?php
class Ventas extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'jquery-ui.min.js'),
            array('script' => 'pages/ventas.js')
        );
        $this->views->getView('ventas', "index", $data);
    }

    public function buscarProducto()
    {
        $data = $this->model->buscarProducto(strClean($_GET['pro']));
        $datos = array();
        foreach ($data as $row) {
            $data = array();;
            $data['id'] = $row['id'];
            $data['label'] = $row['codigo'] . ' - ' . $row['descripcion'];
            $data['cantidad'] = $row['cantidad'];
            $data['value'] = $row['codigo'];
            $data['value_alter'] = $row['codigo_alter'];
            
            $data['precio'] = $row['precio_venta'];
            $data['foto'] = $row['foto'];
            $data['descripcion'] = $row['descripcion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function ingresar($id_pro)
    {
        $datos = $this->model->getProducto($id_pro);
        $precio = $datos['precio_venta'];
        $cantidad = 1;
        $comprobar = $this->model->getComprobar($id_pro, $this->id_usuario, 'detalle_temp');
        $cantidad_dis = $datos['cantidad'];
        if ($cantidad_dis < $cantidad) {
            $msg = array('msg' => 'No hay Stock, te quedan ' . $cantidad_dis, 'icono' => 'warning');
        } else {
            if (empty($comprobar)) {
                $sub_total = $precio * $cantidad;
                $data = $this->model->registrarDetalle($id_pro, $this->id_usuario, $precio, $cantidad, $sub_total);
                if ($data == "ok") {
                    $msg = array('msg' => 'Producto ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al ingresar el producto', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'El producto ya esta agregado', 'icono' => 'error');
            }
        }
        
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function listar($table)
    {
        $data['detalle'] = $this->model->getDetalle($this->id_usuario, $table);
        $data['total_pagar'] = $this->model->calcularTotal($this->id_usuario, $table);
        
        $data['series'] = $this->model->getSeries();
        $data['vendedores'] = $this->model->getVendedores();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function delete($id)
    {
        $data = $this->model->deleteDetalle($id, 'detalle_temp');
        if ($data == 'ok') {
            $msg = array('msg' => 'Producto Eliminado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el producto', 'icono' => 'error');
        }
        echo json_encode($msg);
        die();
    }

    //Precio producto
    public function precioProducto($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $precio = $array[1];
        if (is_numeric($id) && is_numeric($precio)) {
            if ($precio > '') {
                $data = $this->model->actualizarPrecio('detalle_temp', $precio, $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al agregar la precio', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }   

    public function cantidadVenta($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $cant = $array[1];
        if (is_numeric($id) && is_numeric($cant)) {
            if ($cant > 0) {
                $stock = $this->model->verificarStock('detalle_temp', $id);
                if ($cant <= $stock['cantidad']) {
                    $data = $this->model->actualizarCantidad('detalle_temp', $cant, $id);
                    if ($data == 'ok') {
                        $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                    } else {
                        $msg = array('msg' => 'Error al agregar la cantidad', 'icono' => 'error');
                    }
                } else {
                    $this->model->actualizarCantidad('detalle_temp', $stock['cantidad'], $id);
                    $msg = array('msg' => 'Stock Disponible solo ' . $stock['cantidad'], 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    //Historial Ventas
    public function historial()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'sum().js'),
            array('script' => 'pages/historial_ventas.js')
        );
        $this->views->getView('ventas', "historial", $data);
    }

    //Historial Ventas Server Side
    public function historial_ss()
    {
       
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'sum().js'),
            array('script' => 'pages/historial_ventas_ss.js')
        );
        $this->views->getView('ventas', "historial_ss", $data);
    }

    public function listar_ventas()
    {
        $data = $this->model->getHistorial('ventas', $this->id_usuario);
        $autorizacion='';

        for ($i = 0; $i < count($data); $i++) {

            $url = base_url . 'ventas/generarPdf/' . $data[$i]['id'];
            
            //$data[$i]['sucursal']='Sucursal 2';
            //$data[$i]['vendedor']='Vendedor 2 y apellido';

            if($data[$i]['autorizacion']==NULL)
            {
                //$autorizacion='<button class="btn btn-outline-success" type="button" onclick="btnFacturarFel(' . $data[$i]['id'] . ');"><i class="fas fa-file-invoice-dollar"></i></button>';
                $data[$i]['autorizacion_estado']=true;
            } else {
                //$autorizacion='';
                $data[$i]['autorizacion_estado']=false;
            }


            if ($data[$i]['estado'] == 'F') {
                $data[$i]['estado'] = '<span class="badge badge-success">Firmada</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                    '.$autorizacion.'
                    <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <button class="btn btn-outline-warning" type="button" onclick="btnAnular(' . $data[$i]['id'] . ');"><i class="fas fa-ban"></i></button>
                    <div/>';
                $data[$i]['estado_txt']='firmada';
            } else if ($data[$i]['estado'] == 'E') {
                $data[$i]['estado'] = '<span class="badge badge-warning">Emitida</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                    '.$autorizacion.'
                    <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <button class="btn btn-outline-warning" type="button" onclick="btnAnular(' . $data[$i]['id'] . ');"><i class="fas fa-ban"></i></button>
                    <div/>';
                $data[$i]['estado_txt']='emitida';
            } else if ($data[$i]['estado'] == 'A') {
                $data[$i]['estado'] = '<span class="badge badge-danger">Anulado</span>';
                $data[$i]['acciones'] = '<div>
                    '.$autorizacion.'                
                    <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
                $data[$i]['estado_txt']='anulado';
            }

            $data[$i]['nombre']=(!is_null($data[$i]['nombre']))?trim(iso8859_to_utf8($data[$i]['nombre'])):'';
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        
        //var_dump(json_encode($data, JSON_UNESCAPED_UNICODE));

        die();
    }

    public function listar_ventas_ss()
    {
        //$_GET=json_decode('{"url":"ventas\/listar_ventas_ss","sEcho":"2","iColumns":"8","sColumns":",,,,,,,","iDisplayStart":"30","iDisplayLength":"10","mDataProp_0":"0","sSearch_0":"","bRegex_0":"false","bSearchable_0":"true","bSortable_0":"true","mDataProp_1":"1","sSearch_1":"","bRegex_1":"false","bSearchable_1":"true","bSortable_1":"true","mDataProp_2":"2","sSearch_2":"","bRegex_2":"false","bSearchable_2":"true","bSortable_2":"true","mDataProp_3":"3","sSearch_3":"","bRegex_3":"false","bSearchable_3":"true","bSortable_3":"true","mDataProp_4":"4","sSearch_4":"","bRegex_4":"false","bSearchable_4":"true","bSortable_4":"true","mDataProp_5":"5","sSearch_5":"","bRegex_5":"false","bSearchable_5":"true","bSortable_5":"true","mDataProp_6":"6","sSearch_6":"","bRegex_6":"false","bSearchable_6":"true","bSortable_6":"true","mDataProp_7":"7","sSearch_7":"","bRegex_7":"false","bSearchable_7":"true","bSortable_7":"true","sSearch":"","bRegex":"false","iSortCol_0":"0","sSortDir_0":"desc","iSortingCols":"1","fecha_desde":"","fecha_hasta":"","_":"1749827651794"}',true);
        //file_put_contents('./request_get.txt', json_encode($_GET, true));
        $data = $this->model->getHistorial_ss('ventas', $this->id_usuario);

        for ($i = 0; $i < count($data['aaData']); $i++) {

            /*if ($data['aaData'][$i][5] == 'F') {
                $data['aaData'][$i][5] = '<span class="badge badge-success">Firmada</span>';
            } else if ($data['aaData'][$i][5] == 'E') {
                $data['aaData'][$i][5] = '<span class="badge badge-warning">Emitida</span>';
            } else if ($data['aaData'][$i][5] == 'C') {
                $data['aaData'][$i][5] = '<span class="badge badge-danger">Cancelado</span>';
            } else if ($data['aaData'][$i][5] == 'A') {
                $data['aaData'][$i][5] = '<span class="badge badge-danger">Anulado</span>';
            } else if ($data['aaData'][$i][5] == 'P') {
                $data['aaData'][$i][5] = '<span class="badge badge-danger">Pendiente de Anular</span>';                
            }*/

            $data['aaData'][$i][2]=(!is_null($data['aaData'][$i][2]))?trim(iso8859_to_utf8($data['aaData'][$i][2])):'';
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function generarVenta()
    {
        $caja = $this->model->verficarCaja($this->id_usuario);
        if (empty($caja)) {
            $msg = array('msg' => 'La caja esta cerrada', 'icono' => 'warning');
        } else {
            $id_cliente = $_POST['id_cliente'];
            $serie = $_POST['serie'];
            $anotacion = $_POST['anotacion'];
            $vendedor = $_POST['id_vendedor'];
            //$forma = ($_POST['contado']) ? 1 : 2;
            $forma = ($_POST['contado']==='true') ? 1 : 2;
            $tipodoc = $this->model->getTipoDoc($serie);
            $data = $this->model->getDetalle($this->id_usuario, 'detalle_temp');
            $pagar = $this->model->calcularTotal($this->id_usuario, 'detalle_temp');
            $fecha = $_POST['fecha'];
            $hora = date('H:i.s');

            $nombre_cliente = $_POST['nombre_cliente'];
            $tipoid = $_POST['tipoid'];
            $nit = $_POST['nit'];
            $direccion = $_POST['direccion'];
            $mostrador = $_POST['mostrador'];

            /*if($mostrador=='0')
            {
                $msg = array('msg' => 'Cliente '.var_export($direccion,true), 'folio' => 1, 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Cliente Mostrador '.var_export($direccion,true), 'folio' => 1, 'icono' => 'success');
            }*/

            $venta = $this->model->insertarVenta($this->id_usuario, $pagar['total'], $id_cliente, $fecha, $hora, $forma,$serie, $anotacion,$vendedor,$tipodoc);

            if($mostrador=='0')
            {
                $this->model->actualizarClienteVenta($venta);
            } else {
                $this->model->actualizarClienteVentaMostrador($venta,$nombre_cliente,$tipoid,$nit,$direccion);
            }

            /*$msg = array('msg' => var_export($venta,true), 'folio' => 1, 'icono' => 'success');
            echo json_encode($msg, JSON_UNESCAPED_UNICODE);
            return;*/
            
            $this->model->actualizarUltimaFechaVenta($id_cliente);

            if ($venta > 0) {
                if ($forma == 2) {
                    //$this->model->insertarCredito($venta, $pagar['total'], $id_cliente, $pagar['total'], $fecha, $this->id_usuario);
                    $this->model->insertarCredito($venta, $pagar['total'], $id_cliente, $fecha, $this->id_usuario);
                }
                foreach ($data as $row) {
                    $id_pro = $row['id_producto'];
                    $cantidad = $row['cantidad'];
                    $desc = $row['descuento'];
                    $precio = $row['precio'];
                    $sub_total = $row['sub_total'];

                    $this->model->registrar('detalle_ventas', $venta, $id_pro, $cantidad, $desc, $precio, $sub_total);
                    $stock = $this->model->getProducto($id_pro);
                    $total_cantidad = $stock['cantidad'] - $row['cantidad'];
                    $this->model->actualizarStock($total_cantidad, $stock['id']);
                }
                $eliminar = $this->model->eliminarTemp($this->id_usuario, 'detalle_temp');
                $this->model->actualizarDescripciones($venta);
                $this->model->actualizarProductosFechaCompra($venta);
                //$this->model->actualizarTotalesImpuestosDetalle($venta);
                if ($eliminar == 'ok') {
                    $msg = array('msg' => 'Venta Generada', 'folio' => $venta, 'icono' => 'success');

                }
            } else {
                $msg = array('msg' => 'Error al generar la venta', 'icono' => 'error');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function descuentoVenta($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $desc = $array[1];
        if (is_numeric($id) && is_numeric($desc)) {
            $data = $this->model->actualizarDescuento('detalle_temp', $desc, $id);
            if ($data == 'ok') {
                $msg = array('msg' => 'Descuento Agregado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al agregar el descuento', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }


    //pdf ventas
    public function generarPdf($folio)
    {

       $data['estilo'] = 'reporte.css';
       $data['logo_tamanio'] = 250;
       $data['empresa'] = $this->model->getEmpresa();
       $data['venta'] = $this->model->getVenta($folio);
       $data['detalle'] = $this->model->detalleVentas($folio);
       $data['sucursal'] = $this->model->getSucursal($folio);
       $data['color']='#067d2e';

      
        $number = $data['venta']['total'];
        $integerPart = floor($number);
        $decimalPart = $number - $integerPart;
        $data['total_letras']=strtoupper(convertir($integerPart).' CON '.$decimalPart.'/100 QUETZALES');


        //Cambiar esto, me imagino hay que copiar el controller qr de divemosa hacia aca
        /*$feedUrl = 'https://ad.divemosa.com/inventario/Controllers/qr/index.php?numero='.$data['venta']['autorizacion'].'&receptor='.$data['venta']['nitcliente'].'&monto='.$data['venta']['total'];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $feedUrl);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
        $rawFeed = curl_exec($ch);
        $error   = curl_error($ch);
        curl_close($ch);

        $data['qr']='data:image/png;base64,'.base64_encode($rawFeed);*/

        ob_start();

        //$data['venta']["tipodoc"] FACT | FCAM

//        if($data['venta']["tipodoc"]=='FACT')
//        {
//            $html = $this->views->getView('ventas', "formato_fact", $data);
//        } else {
//            $html = $this->views->getView('ventas', "formato_fcam", $data);
//        }

        

        $html = $this->views->getView('ventas', "copia_factura", $data);        

        echo $html;
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        if ($data['venta']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }

        $mpdf = new \Mpdf\Mpdf([
            'format' => 'Letter',
            'orientation' => 'P',
            'margin_left' => 10,
            'margin_right' => 10,
            'margin_top' => 3,
            'margin_bottom' => 3
        ]);

       
        $mpdf->WriteHTML($html);
        $mpdf->Output('Factura-'.$data['venta']['numfel'].'.pdf',"I");
    }

    public function ticket($folio)
    {
        $data['estilo'] = 'ticket.css';
        $data['logo_tamanio'] = 50;
        $data['empresa'] = $this->model->getEmpresa();
        $data['venta'] = $this->model->getVenta($folio);
        $data['detalle'] = $this->model->detalleVentas($folio);
        ob_start();
        $html = $this->views->getView('ventas', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => [48, 210],
            'margin_left' => 2,
            'margin_right' => 2,
            'margin_top' => 0,
            'margin_bottom' => 0
        ]);

        if ($data['venta']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }

    public function solicitarToken($sucursal)
    {
        require_once('./Config/Fel.php');
        $sucursalc = $this->model->getSucursalID($sucursal);

        $trad['{{USERFEL}}']=$sucursalc["feliduser"];
        $trad['{{APIKEY}}']=$sucursalc["felapikey"];

        $requestXMLST=strtr($requestXML_solicitarToken,$trad);
        $result=requestToken( $requestXMLST,$solicitar_token);

        if($result["tipo_respuesta"]=='0')
        {
            $msg = array('msg' => 'Token Generado', 'icono' => 'success');
            $datos_token = $this->model->registrarToken($result["token"],$result["vigencia"], $sucursal );
        } else {
            $msg = array('msg' => '['.$result["listado_errores"]["error"]["cod_error"].'] '.$result["listado_errores"]["error"]["desc_error"], 'icono' => 'error');
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();        
    }


    public function anular($id)
    {
        if (isset($_GET)) {
            require_once('./Config/Fel.php');
            
            //$existe = $this->model->getDetalleVenta('detalle_ventas', $id);
            $existe = $this->model->getDetalleVenta('facturadet', $id);
            $factura = $this->model->getVenta($id);
            $sucursal = $this->model->getSucursal($id);
            $token = $this->model->getTokenActivo($sucursal["iduser"]);

            if($factura['autorizacion']===NULL || trim($factura['autorizacion'])=="" )
            {
                $FechaAnulacionMYSQL = date ( 'Y-m-d H:i:s');
                $uuid_anulacion='';
                // verificar existe para actualizar stock
                /*foreach ($existe as $row) {
                    $stock = $this->model->getProducto($row['id_producto']);
                    $cantidad = $stock['cantidad'] + $row['cantidad'];
                    $this->model->actualizarStock($cantidad, $stock['id']);
                }*/
                //if ($factura['forma_pago'] == 2) { $this->model->anularCredito('creditos', $id); }

                $data = $this->model->anular($id , $uuid_anulacion , $FechaAnulacionMYSQL); // verificar modelo anular
                $msg = array('msg' => 'Factura Anulada', 'icono' => 'success');

            } else {
             

                if (!empty($existe)) {

                    $dateanul=strtotime ( '-2 minute');
                    $FechaAnulacion = date ( 'Y-m-d\TH:i:s' , $dateanul );
                    $FechaAnulacionMYSQL = date ( 'Y-m-d H:i:s' , $dateanul );
                    $FechaProc = date ( 'Y-m-d\TH:i:s' , strtotime ($factura['fechaproc']) );

                    $trad['{{NITCLIENTE}}']=$factura['nitcliente'];
                    $trad['{{AUTORIZACION}}']=$factura["autorizacion"];
                    $trad['{{FECHAANUL}}']=$FechaAnulacion;
                    $trad['{{FECHAPROC}}']=$FechaProc;
                    $trad['{{EMISOR_NIT}}']=$sucursal["nit"];
                    $trad['{{UUID}}']=gen_uuid();

                    $requestXML=strtr($requestXML_anulacion,$trad);

                    $curl_response=requestXML($requestXML,$firmar_documento,$token['token']);

                    if($curl_response["tipo_respuesta"]=='0')
                    {
                        $uuid_registro=$curl_response["uuid"];
                        $uuid_firma=gen_uuid();
            
                        $requestXML="<?xml version='1.0' encoding='UTF-8'?>
                        <AnulaDocumentoXMLRequest id='{$uuid_firma}'>
                                <xml_dte> <![CDATA[ {$curl_response["xml_dte"]} ]]> </xml_dte>
                        </AnulaDocumentoXMLRequest>";                    
            
                        $curl_response=requestXML($requestXML,$anular_documento,$token['token']);

                        $uuid_anulacion=$curl_response["uuid"]; // insertar

                        if($curl_response["tipo_respuesta"]=='0')
                        {
                            $this->model->insertarXML_FCAM($id,$FechaAnulacionMYSQL,$curl_response["xml_dte"],'');
                            /*foreach ($existe as $row) {
                                $stock = $this->model->getProducto($row['id_producto']);
                                $cantidad = $stock['cantidad'] + $row['cantidad'];
                                $this->model->actualizarStock($cantidad, $stock['id']);
                            }                        
                            if ($factura['forma_pago'] == 2) { $this->model->anularCredito('creditos', $id); }*/
                            
                            $data = $this->model->anular($id , $uuid_anulacion , $FechaAnulacionMYSQL);// verificar
                            
                            $msg = array('msg' => 'Factura Anulada', 'icono' => 'success');
                        } else {
                            $this->model->insertarXML_FCAM($id,$FechaAnulacionMYSQL,$requestXML,mostrar_errores2($curl_response["listado_errores"]));
                            $msg = array('msg' => mostrar_errores2($curl_response["listado_errores"]), 'icono' => 'danger');
                        }
                    } else {
                        $msg = array('msg' => mostrar_errores2($curl_response["listado_errores"]), 'icono' => 'danger');
                    }

                } else {
                    $msg = array('msg' => 'Error al anular la venta', 'icono' => 'error');
                }
            }
            echo json_encode($msg, JSON_UNESCAPED_UNICODE);
            die();
        }
    }

    public function registrarFactura($numdoc)
    {
        require_once('./Config/Fel.php');

        //$detalle = $this->model->getDetalleVenta('detalle_ventas', $numdoc);
        $detalle = $this->model->getDetalleVenta('facturadet', $numdoc);

        $factura = $this->model->getVenta($numdoc);
        $sucursal = $this->model->getSucursal($numdoc);

        // verificar token activo de que base de datos lo saco
        $token = $this->model->getTokenActivo($sucursal["iduser"]);        

        date_default_timezone_set("America/Guatemala");
        $fechafinalemision=strtotime ( '-2 minute');
        $FechaHoraEmisionMYSQL = date ( 'Y-m-d H:i:s' , $fechafinalemision );
        $FechaHoraEmision = date ( 'Y-m-d\TH:i:s' , $fechafinalemision );
        $FechaVencimiento = date ( 'Y-m-d' , strtotime ( '-2 minute +1month') );        

        $items='';
        if(is_array($detalle))
        {
            $linea=1;
            foreach ($detalle as $value)
            {
                    $items.="<dte:Item BienOServicio='{$value['bienservicio']}' NumeroLinea='{$linea}'>
                        <dte:Cantidad>{$value['cantidad']}</dte:Cantidad>
                        <dte:UnidadMedida>{$value['unimed']}</dte:UnidadMedida>
                        <dte:Descripcion>".trim($value['descripcion'])."</dte:Descripcion>
                        <dte:PrecioUnitario>{$value['precio']}</dte:PrecioUnitario>
                        <dte:Precio>{$value['sub_total']}</dte:Precio>
                        <dte:Descuento>{$value['descuento']}</dte:Descuento>
                        <dte:Impuestos>
                        <dte:Impuesto>
                        <dte:NombreCorto>IVA</dte:NombreCorto>
                        <dte:CodigoUnidadGravable>1</dte:CodigoUnidadGravable>
                        <dte:MontoGravable>{$value['mgravable']}</dte:MontoGravable>
                        <dte:MontoImpuesto>{$value['iva']}</dte:MontoImpuesto>
                        </dte:Impuesto>
                        </dte:Impuestos>
                        <dte:Total>{$value['total']}</dte:Total>
                    </dte:Item>
                    ";
                    $linea++;
            }
        }
        $mgravable=round($factura["total"]/1.12,2);
        //*$iva=number_format($factura["total"]-$mgravable,2);
        $iva=$factura["total"]-$mgravable;        

        $trad['{{EMISOR_AfiliacionIVA}}']= $sucursal["afiliacion_iva"];
        $trad['{{EMISOR_CodigoEstablecimiento}}']= $sucursal["establecimiento"];
        $trad['{{EMISOR_CodigoPostal}}']= $sucursal["cpostal"];
        $trad['{{EMISOR_CorreoEmisor}}']= $sucursal["correo"];
        $trad['{{EMISOR_Departamento}}']= $sucursal["departamento"];
        $trad['{{EMISOR_Municipio}}']= $sucursal["municipio"];
        $trad['{{EMISOR_Direccion}}']= $sucursal["direccion"];
        $trad['{{EMISOR_NIT}}']= $sucursal["nit"];
        $trad['{{EMISOR_NombreComercial}}']= $sucursal["comercio"];
        $trad['{{EMISOR_NombreEmisor}}']= $sucursal["emisor"];

        $trad['{{TIPODOCUMENTO}}']=$sucursal["tipo_fact"];
        $trad['{{UUID}}']=gen_uuid();
        $trad['{{FECHAHORAEMISION}}']=$FechaHoraEmision;
        $trad['{{FECHAVENCIMIENTO}}']=$FechaVencimiento;
        $trad['{{TOTALMONTOIMPUESTO}}']=$iva;
        $trad['{{GRANTOTAL}}']=$factura["total"];
        $trad['{{NITRECEPTOR}}']=$factura["nitcliente"];
        $trad['{{NOMBRERECEPTOR}}']=trim($factura["nomcliente"]);
        $trad['{{DIRECCIONRECEPTOR}}']=trim($factura["direccion"]);
        $trad['{{CPRECEPTOR}}']=0;
        $trad['{{MUNICIPIORECEPTOR}}']=trim($factura["municipio"]);
        $trad['{{DEPARTAMENTORECEPTOR}}']=trim($factura["departamento"]);
        $trad['{{PAISRECEPTOR}}']=strtoupper(trim($factura["pais"]));

        $trad['{{ITEMS}}']=$items;
        $trad['{{CODIGOVENDEDOR}}']=trim($factura["id_usuario"]);
        $trad['{{NUMDOC}}']=$numdoc;

        
        if($factura["tipoid"]==1) {
            $trad['{{TIPOESPECIAL}}']='';
        } else if($factura["tipoid"]==2) {
            $trad['{{TIPOESPECIAL}}']="TipoEspecial='CUI'";
        } else if($factura["tipoid"]==3) {
            $trad['{{TIPOESPECIAL}}']="TipoEspecial='EXT'";
        }

        $requestXML=strtr($requestXML_header,$trad);

        $curl_response=requestXML($requestXML,$firmar_documento,$token['token']);

        if($curl_response["tipo_respuesta"]=='0')
        {
            //$msg = array('msg' => 'Factura Generada', 'icono' => 'success');
            $uuid_registro=$curl_response["uuid"];
            $uuid_firma=gen_uuid();

            $requestXML="<?xml version='1.0' encoding='UTF-8'?>
            <RegistraDocumentoXMLRequest id='{$uuid_firma}'>
            <xml_dte><![CDATA[ {$curl_response["xml_dte"]} ]]>
            </xml_dte>
            </RegistraDocumentoXMLRequest>";

            $curl_response=requestXML($requestXML,$registrar_xml,$token['token']);

            $uuid_autorizacion=$curl_response["uuid"];
            
            if($curl_response["tipo_respuesta"]=='0')
            {
                $nfactura=convert_id_number($uuid_autorizacion);
                $serial=$nfactura['serial'];
                $number=$nfactura['number'];
                
                $this->model->insertarXML_FCAM($numdoc,$FechaHoraEmisionMYSQL,$curl_response["xml_dte"],'');


                // actualizarFacturaVentasFEL para que trabaje con la tabla facturaenc
                $this->model->actualizarFacturaVentasFEL($numdoc,$serial,$number,$uuid_autorizacion,$FechaHoraEmisionMYSQL,$uuid_firma,$uuid_registro);
                //$this->model->actualizarProductosFechaCompra($numdoc);
                $msg = array('msg' => 'Factura Generada', 'icono' => 'success');
            } else {
                $this->model->insertarXML_FCAM($numdoc,$FechaHoraEmisionMYSQL,$requestXML,mostrar_errores2($curl_response["listado_errores"]));
                $msg = array('msg' => mostrar_errores2($curl_response["listado_errores"]), 'icono' => 'danger');
            }
        } else {
            $this->model->insertarXML_FCAM($numdoc,$FechaHoraEmisionMYSQL,$requestXML,mostrar_errores2($curl_response["listado_errores"]));
            $msg = array('msg' => mostrar_errores2($curl_response["listado_errores"]), 'icono' => 'danger');
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

}

function basico($numero) {
    $valor = array ('uno','dos','tres','cuatro','cinco','seis','siete','ocho',
    'nueve','diez','once','doce','trece','catorce','quince','dieciseis','diecisiete','dieciocho','diecinueve','veinte','veintiuno ','vientidos ','VEINTITRÉS ', 'veinticuatro','veinticinco',
    'VEINTISÉIS','veintisiete','veintiocho','veintinueve');
    return $valor[$numero - 1];
    }
    
    function decenas($n) {
    $decenas = array (30=>'treinta',40=>'cuarenta',50=>'cincuenta',60=>'sesenta',
    70=>'setenta',80=>'ochenta',90=>'noventa');
    if( $n <= 29) return basico($n);
    $x = $n % 10;
    if ( $x == 0 ) {
    return $decenas[$n];
    } else return $decenas[$n - $x].' y '. basico($x);
    }
    
    function centenas($n) {
    $cientos = array (100 =>'cien',200 =>'doscientos',300=>'trecientos',
    400=>'cuatrocientos', 500=>'quinientos',600=>'seiscientos',
    700=>'setecientos',800=>'ochocientos', 900 =>'novecientos');
    if( $n >= 100) {
    if ( $n % 100 == 0 ) {
    return $cientos[$n];
    } else {
    $u = (int) substr($n,0,1);
    $d = (int) substr($n,1,2);
    return (($u == 1)?'ciento':$cientos[$u*100]).' '.decenas($d);
    }
    } else return decenas($n);
    }
    
    function miles($n) {
    if($n > 999) {
    if( $n == 1000) {return 'mil';}
    else {
    $l = strlen($n);
    $c = (int)substr($n,0,$l-3);
    $x = (int)substr($n,-3);
    if($c == 1) {$cadena = 'MIL '.centenas($x);}
    else if($x != 0) {$cadena = centenas($c).' MIL '.centenas($x);}
    else $cadena = centenas($c). ' MIL';
    return $cadena;
    }
    } else return centenas($n);
    }
    
    function millones($n) {
    if($n == 1000000) {return 'UN MILLÓN';}
    else {
    $l = strlen($n);
    $c = (int)substr($n,0,$l-6);
    $x = (int)substr($n,-6);
    if($c == 1) {
    $cadena = ' MILLÓN ';
    } else {
    $cadena = ' MILLONES ';
    }
    return miles($c).$cadena.(($x > 0)?miles($x):'');
    }
    }
    function convertir($n) {
    switch (true) {
    case ( $n >= 1 && $n <= 29) : return basico($n); break;
    case ( $n >= 30 && $n < 100) : return decenas($n); break;
    case ( $n >= 100 && $n < 1000) : return centenas($n); break;
    case ($n >= 1000 && $n <= 999999): return miles($n); break;
    case ($n >= 1000000): return millones($n);
    }
    }