<?php
class CreditoventasModel extends Query
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getCountRecibos(int  $id_usuario)
    {
        $sql = "SELECT CONCAT(`id`,'-',LPAD(`countRecibos`+1, 6, '0')) AS nrecibo FROM `usuarios` WHERE `id`='{$id_usuario}'";
        $data = $this->select($sql);
        return $data['nrecibo'];
    }
    public function addCountRecibos(int  $id_usuario)
    {
        $sql = "UPDATE usuarios SET countRecibos=countRecibos+1 WHERE `id`=?";
        $datos = array($id_usuario);
        $data = $this->insertar($sql, $datos);
        return $data;
    }

    public function getCreditos(int $id_usuario)
    {
        if ($id_usuario<=100)
        {
            $sql = "SELECT c.nombre, cr.*,concat('[',u.iduser,']-',u.user) AS sucursal,v.estado AS estatus FROM clientes c INNER JOIN creditos cr ON c.id = cr.cliente INNER JOIN vales v ON cr.venta = v.id INNER JOIN ws_users u ON v.serie = u.iduser";
        } else
        {
            $sql = "SELECT c.nombre, cr.*,concat('[',u.iduser,']-',u.user) AS sucursal,v.estado AS estatus FROM clientes c INNER JOIN creditos cr ON c.id = cr.cliente INNER JOIN vales v ON cr.venta = v.id INNER JOIN ws_users u ON v.serie = u.iduser WHERE cr.id_usuario = $id_usuario";
        }
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getCreditosCliente(int $id_cliente)
    {

        //$sql = "SELECT `venta` as numero, `monto` as total, `abonado` as abono, `restante` as saldo, `fecha`, `id_interno` as idinterno FROM `creditos` WHERE `monto`>`abonado` AND `cliente`= {$id_cliente} AND `estado`!=2";
        $sql = "SELECT `numdoc` as numero, `total`, `total`-`saldo` as abono, `saldo`, `fechadoc` as fecha, `numdoc` as idinterno FROM `".prefixant."`.`facturaenc` WHERE `saldo`>0 AND `codcliente`= {$id_cliente} AND `estado`='F'";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getAbonos(int $id_usuario)
    {

        //echo($id_usuario);
        //var_dump($id_usuario);

        if ($id_usuario<=101)
        {
            $sql = "SELECT c.nombre,concat('[',u.iduser,']-',u.user) AS sucursal, a.* FROM clientes c INNER JOIN abonos a ON c.id = a.id_cliente INNER JOIN ws_users u ON a.id_usuario = u.iduser";
            
        } else
        {
            $sql = "SELECT c.nombre,concat('[',u.iduser,']-',u.user) AS sucursal, a.* FROM clientes c INNER JOIN abonos a ON c.id = a.id_cliente WHERE a.id_usuario = $id_usuario";
        }

        $data = $this->selectAll($sql);
        return $data;
    }
    public function datoAbono(int $id)
    {
        $sql = "SELECT c.nombre, c.telefono, a.*, cr.id, cr.monto AS total, cr.abonado, cr.restante FROM clientes c INNER JOIN abonos a ON c.id = a.id_cliente INNER JOIN creditos cr ON cr.id = a.id_credito INNER JOIN ws_users u ON a.id_usuario = u.iduser WHERE a.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    public function registrarAbono(int $id_credito, int $id_cliente,string $monto, string $fecha, string $hora, int $id_usuario, string $fecha_abono, string $metodo, string $observaciones, string $referencias, int $banco)
    {
        $sql = "SELECT CONCAT(`id`,'-',LPAD(`countRecibos`+1, 6, '0')) AS nrecibo FROM `usuarios` WHERE `id`='{$id_usuario}'";
        $data = $this->select($sql);
        return $data['nrecibo'];

        $sql = "INSERT INTO abonos(id_credito, id_cliente,monto, fecha, hora, id_usuario, metodo_pago, fecha_abono, observaciones, referencias, id_banco ) VALUES (?,?,?,?,?,?, ?,?,?,?,?)";
        $datos = array($id_credito, $id_cliente,$monto, $fecha, $hora, $id_usuario,$metodo, $fecha_abono, $observaciones, $referencias, $banco);
        $data = $this->save($sql, $datos);
        return $data;
    }

    public function registrarAbonos(int $id_cliente,string $monto, string $fecha, string $hora, int $id_usuario, string $fecha_abono, string $metodo, string $observaciones, string $referencias, int $banco, string $nrecibo)
    {
        $sql = "INSERT INTO abonos (id_cliente, monto, fecha, hora,  id_usuario, metodo_pago, fecha_abono, observaciones, referencias, id_banco ,rec_numero) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        $datos = array($id_cliente, $monto, $fecha, $hora, $id_usuario, $metodo, $fecha_abono, $observaciones, $referencias, $banco, $nrecibo);
        $data = $this->insertar($sql, $datos);
        return $data;
    }

    public function registrarAbonoDetalle(int $id_abono,int $id_credito, string $abono)
    {
        $sql = "INSERT INTO abonos_detalle (id_abono, id_credito, abono ) VALUES (?,?,?)";
        $datos = array($id_abono, $id_credito, $abono);
        $data = $this->insertar($sql, $datos);
        return $data;
    }

    public function registrarAbonoCredito(int $id_credito, string $abono)
    {
        $sql = "UPDATE creditos SET restante = restante-?, abonado =abonado+? WHERE venta = ?";
        $datos = array($abono, $abono, $id_credito);
        $data = $this->insertar($sql, $datos);

        $sql = "UPDATE creditos SET `estado`= '3' WHERE (`monto`-`abonado`)=0 AND `abonado`>0  AND venta = ?";
        $datos = array($id_credito);
        $data = $this->insertar($sql, $datos);

        return $data;
    }
    
    public function registrarEstadoAbono(int $id_credito)
    {
        $sql = "UPDATE creditos SET estado=0 WHERE venta = ? AND restante=0";
        $datos = array($id_credito);
        $data = $this->insertar($sql, $datos);
        return $data;
    }
    
    public function getAbonoPDF(int $id)
    {
        //$id=181;

        $sql = "SELECT 
        r.rec_cod as id_cliente
        ,c.direccion as direccion
        ,c.nit as nit
        ,c.tipoid as tipoid
        ,c.nombre as nombre
        ,CASE
                WHEN r.rec_tipo = 0 THEN 'NO SELECCIONADO'
                WHEN r.rec_tipo = 1 THEN 'EFECTIVO'
                WHEN r.rec_tipo = 2 THEN 'CHEQUE'
                WHEN r.rec_tipo = 3 THEN 'DEPOSITO'
                WHEN r.rec_tipo = 4 THEN 'OTROS' 
        END as metodo
        ,rec_id as id
        ,0 as id_credito
        ,r.rec_abono as monto
        ,r.rec_fecha as fecha
        ,'00:00:00' as hora
        ,r.rec_codven as id_usuario
        ,1 as apertura
        ,CASE
                WHEN r.rec_tipo = 0 THEN 'NO SELECCIONADO'
                WHEN r.rec_tipo = 1 THEN 'EFECTIVO'
                WHEN r.rec_tipo = 2 THEN 'CHEQUE'
                WHEN r.rec_tipo = 3 THEN 'DEPOSITO'
                WHEN r.rec_tipo = 4 THEN 'OTROS' 
        END as metodo_pago
        ,r.rec_fecha as fecha_abono
        ,r.rec_obs as observaciones
        ,r.rec_ref as referencias
        ,r.rec_estado as estado
        ,r.rec_banco as id_banco
        ,r.rec_numero as rec_numero


        FROM `".prefixant."`.`recibos` r
        INNER JOIN clientes c ON r.rec_cod=c.id
        WHERE r.rec_id = $id";
        $data = $this->select($sql);
        return $data;
    }

/*    public function getAbonoPDF_anterior(int $id)
    {
        $sql = "SELECT c.id AS id_cliente, c.direccion AS direccion, UPPER(c.nit) AS nit, c.tipoid as tipoid, c.nombre, UPPER(me.nombre) as metodo, ab.* 
        FROM clientes c 
        INNER JOIN abonos ab ON c.id = ab.id_cliente 
        INNER JOIN metodo_pago me ON ab.metodo_pago = me.codme
        WHERE ab.id = $id";
        $data = $this->select($sql);
        return $data;
    }*/

    public function getAbonoDetallePDF(int $id)
    {
        $sql = "SELECT
        d.rec_id as id_abono
        ,d.id as id_credito
        , d.abono as abono
        , d.numdoc as interno
        , DATE_FORMAT(d.fecha,'%d/%m/%Y') as fecha
        FROM `".prefixant."`.`recibosdet` d
        WHERE d.rec_id= $id
        ORDER BY id";

        $data = $this->selectAll($sql);
        return $data;
    }

/*    public function getAbonoDetallePDF2(int $id)
    {
        $sql = "SELECT ab.id_abono as id_abono, ab.id_credito as id_credito, ab.abono as abono, fac.numfel as interno, DATE_FORMAT(fac.fechadoc,'%d/%m/%Y') as fecha
        FROM `abonos_detalle` ab
        INNER JOIN `".prefixant."`.`facturaenc` fac ON fac.`numdoc` = ab.id_credito
        WHERE ab.id_abono= $id
        ORDER BY id_credito";

        $data = $this->selectAll($sql);
        return $data;
    }*/

	public function getSucursalID(int $sucursal)
    {
        $sql = "SELECT * FROM `ws_users` WHERE iduser='{$sucursal}'";
        $data = $this->select($sql);
        return $data;
    }

    public function getMetodos()
    {
        $sql = "SELECT codme, nombre FROM metodo_pago";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getBancos()
    {
        $sql = "SELECT id, nombre_banco as nombre FROM bancos";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function autorizaAbono(int $id)
    {
        // Cambia estado abono
        $sql = "UPDATE abonos SET estado = 3 WHERE id = ?";
        $datos = array($id);
        $data = $this->save($sql, $datos);

        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function rechazarAbono(int $id)
    {
        // Cambia datos tabla abonos
        $sql = "UPDATE abonos SET estado = 2, monto =0 WHERE id = ?";
        $datos = array($id);
        $data = $this->save($sql, $datos);

        // Cambia datos tabla creditos
        $sql = "UPDATE `creditos` cre
        INNER JOIN `abonos_detalle` ab ON ab.id_credito=cre.id
        SET cre.estado=1, cre.abonado=cre.abonado-ab.abono, cre.restante=cre.restante+ab.abono
        WHERE ab.id_abono=?";
        $datos = array($id);
        $data = $this->save($sql, $datos);

        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }

        return $res;
    }
    

    public function getAbono(int $id)
    {
        $sql = "SELECT c.id AS id_cliente, c.nombre, cr.* 
        FROM clientes c INNER JOIN creditos cr ON c.id = cr.cliente WHERE cr.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function actualizarCredito(string $table,string $monto, string $restante, int $id)
    {
        $sql = "UPDATE $table SET abonado = ?, restante = ? WHERE id = ?";
        $datos = array($monto, $restante,$id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function estado(string $table,int $estado, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function getCajaCierre(int $id)
    {
        $sql = "SELECT id, id_usuario, monto_inicial, estado FROM cajas_cierre WHERE id_usuario = $id AND estado = 1";
        $data = $this->select($sql);
        return $data;
    }
    public function detalleCredito(int $id)
    {
        $sql = "SELECT c.*, d.*, p.descripcion FROM creditos c INNER JOIN detalle_ventas d ON d.folio = c.venta INNER JOIN productos p ON d.id_producto = p.id WHERE c.id = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function detalleCliente(int $id)
    {
        $sql = "SELECT c.*, cl.id, cl.nombre, cl.telefono, cl.direccion, v.estado AS estatus FROM creditos c INNER JOIN clientes cl ON c.cliente = cl.id INNER JOIN vales v ON c.venta = v.id WHERE c.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function detalleAbono(int $id)
    {
        $sql = "SELECT a.monto AS abono, a.fecha, c.*, cl.nombre FROM abonos a INNER JOIN creditos c ON a.id_credito = c.id INNER JOIN clientes cl ON a.id_cliente = cl.id WHERE a.id_credito = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function estadoVenta(int $id)
    {
        $sql = "SELECT cr.venta FROM vales v INNER JOIN creditos cr ON v.id = cr.venta WHERE cr.id = $id";
        $data = $this->select($sql);
        return $data;
    }

    public function buscarCliente(string $nombre)
    {
        $sql = "SELECT * FROM clientes WHERE nombre LIKE '%" . $nombre . "%' AND estado = 1 LIMIT 10";
        $data = $this->selectAll($sql);
        return $data;
    }    

}
